<?php $__env->startSection('site-title'); ?>
    <?php echo e(__('All Campaign Withdraw Requests')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-lg-12 col-ml-12 padding-bottom-30">
        <div class="row">
            <div class="col-lg-12 mt-5">
                <div class="card">
                    <div class="card-body">
                        <div class="header-wrap d-flex justify-content-between">
                            <h4 class="header-title"><?php echo e(__('Withdraw Details')); ?></h4>
                            <div class="btn-wrapper">
                                <a class="btn btn-info" href="<?php echo e(route('admin.all.donation.withdraw.request')); ?>"><?php echo e(__('All Withdraw')); ?></a>
                            </div>
                        </div>
                        <ul class="margin-top-20">
                            <li><strong><?php echo e(__('Cause')); ?>:</strong> <?php echo e(optional($withdraw->cause)->title ?? __('untitled')); ?> </li>
                            <li><strong><?php echo e(__('Requested By')); ?>:</strong> <?php echo e(optional($withdraw->user)->name); ?> (<?php echo e(optional($withdraw->user)->username); ?>)</li>
                            <?php if($withdraw->payment_status === 'pending'): ?>
                                <li><strong><?php echo e(__('Raised Amount')); ?>:</strong> <?php echo e(amount_with_currency_symbol(optional($withdraw->cause)->raised ?? 0)); ?></li>
                            <?php
                                $withdraw_able_amount_without_admin_charge = optional($withdraw->cause)->raised - optional($withdraw->cause)->withdraws->where('payment_status' , 'approved')->pluck('withdraw_request_amount')->sum();
                               $charge_text = '';
                               $donation_charge_form = get_static_option('donation_charge_form');
                               if ($donation_charge_form === 'campaign_owner'){
                                   $charge_text = __('after admin charge applied');
                                   echo '<li><strong>'.__('Admin Charged From This Campaign').': </strong> '.amount_with_currency_symbol( \App\Helpers\DonationHelpers::get_donation_charge_for_campaign_owner($withdraw_able_amount_without_admin_charge)).'</li>';
                                   $withdraw_able_amount_without_admin_charge -= \App\Helpers\DonationHelpers::get_donation_charge_for_campaign_owner($withdraw_able_amount_without_admin_charge);
                               }
                            ?>
                                <li><strong><?php echo e(__('Available For Withdraw Amount').' '.$charge_text); ?>:</strong><?php echo e(amount_with_currency_symbol($withdraw_able_amount_without_admin_charge)); ?> </li>
                            <?php endif; ?>
                            <li><strong><?php echo e(__('Requested Withdraw Amount')); ?>:</strong> <?php echo e(amount_with_currency_symbol($withdraw->withdraw_request_amount)); ?> </li>
                            <li><strong><?php echo e(__('Payment Gateway')); ?>:</strong> <?php echo e($withdraw->payment_gateway); ?> </li>
                            <li><strong><?php echo e(__('Payment Status')); ?>:</strong> <?php echo e($withdraw->payment_status); ?> </li>
                            <li><strong><?php echo e(__('Date')); ?>:</strong> <?php echo e($withdraw->created_at->format('D, d M Y')); ?> </li>
                            <?php if($withdraw->payment_status === 'approved'): ?>
                                <li><strong><?php echo e(__('Approved Date')); ?>:</strong> <?php echo e($withdraw->updated_at->format('D, d M Y')); ?> </li>
                            <?php endif; ?>
                            <li><strong><?php echo e(__('Payment Account Details ')); ?>:</strong> <?php echo e($withdraw->payment_account_details); ?> </li>
                            <li><strong><?php echo e(__('Additional Comment by user')); ?>:</strong> <?php echo e($withdraw->additional_comment_by_user); ?> </li>
                        </ul>
                        <h3 class="header-title margin-top-40"><?php echo e(__('Admin Response')); ?></h3>
                        <ul class="margin-top-20">
                            <li><strong><?php echo e(__('Transaction Id')); ?>:</strong> <?php echo e($withdraw->transaction_id); ?> </li>
                            <li><strong><?php echo e(__('Payment Receipt')); ?>:</strong>
                                <?php if($withdraw->payment_receipt && file_exists('assets/uploads/donation-withdraw/'.$withdraw->payment_receipt)): ?>
                                    <a href="<?php echo e(asset('assets/uploads/donation-withdraw/'.$withdraw->payment_receipt)); ?>" download=""><?php echo e($withdraw->payment_receipt); ?></a>
                                <?php else: ?>
                                    <?php echo e($withdraw->payment_receipt); ?>

                                <?php endif; ?>
                            </li>
                            <li><strong><?php echo e(__('Payment information')); ?>:</strong> <?php echo e($withdraw->payment_information); ?> </li>
                            <li><strong><?php echo e(__('Additional Comment by Admin')); ?>:</strong> <?php echo e($withdraw->additional_comment_by_admin); ?> </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.admin-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\fundor\@core\resources\views/backend/donations/donation-withdraw-view.blade.php ENDPATH**/ ?>